package com.androidbook.pettracker3;

// Klasa pomocnicza grupująca dane na temat konkretnego zwierzaka.
// Pozwala także na porównywanie rekordów poszczegónych wierzaków.
public class PetRecord implements Comparable<PetRecord>{ 
	    
	     public static final long INVALID_PET_ID = -1;
	     public static final long INVALID_PET_IMAGE_ID = -1;
	     private String mPetName; 
	     private String mPetType; 
	     private String mPetImageUriPath; 
	     private long mPetImageId = INVALID_PET_IMAGE_ID; //(Znacznik URI)
	     private long mPetId = INVALID_PET_ID; //(Identyfikator unikalnego klucza głównego tabeli)
	     
	     private boolean mSelectable = true; 

	     public PetRecord(String petName, String petType, String strImageUriPath, Long petImageId, Long petId) { 
		     mPetName = petName; 
		     mPetType = petType; 
		     mPetImageUriPath = strImageUriPath;
		     mPetImageId = petImageId; 
		     mPetId = petId; // w przypadku niezapisanych zwierzaków właściwość ta będzie mieć wartość INVALID_PET_ID.
	     } 
	      
	     public boolean isSelectable() { 
	          return mSelectable; 
	     } 
	      
	     public void setSelectable(boolean selectable) { 
	          mSelectable = selectable; 
	     } 
	      
	     public String getPetName() { 
	          return mPetName; 
	     } 
	      
	     public void setPetName(String text) { 
	    	 mPetName = text; 
	     } 
	     
	     public String getPetImageUriPath() { 
	          return mPetImageUriPath; 
	     } 
	      
	     public void setPetImageUriPath(String text) { 
	    	 mPetImageUriPath = text; 
	     } 
	     
	     public String getPetType() { 
	          return mPetType; 
	     } 
	      
	     public void setPetType(String text) { 
	    	 mPetType = text; 
	     } 
	      
	     public long getPetImageId() { 
	          return mPetImageId; 
	     } 
	      
	     public void setPetImageId(long id) { 
	    	 mPetImageId = id; 
	     } 
	     
	     public long getPetId() { 
	          return mPetId; 
	     } 
	      
	     public void setPetId(long id) { 
	    	 mPetId = id; 
	     } 

	     public int compareTo(PetRecord other) { 
	          return (int)((this.mPetId)-(other.mPetId));
	     } 
	} 



